/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.vues.ecrans.saisie;

import fr.asip.cps3.exemple.modele.objets.Algo;
import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;
import fr.asip.cps3.exemple.vues.ecrans.saisie.Saisie;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class SaisieFichier
extends Saisie
implements ActionListener {
    protected Algo algo;
    protected JLabel libelleFichier;
    protected JTextField texteFichier;
    protected JButton boutonParcourir;

    public SaisieFichier(FenetrePrincipale fenetrePrincipale, int n, Algo algo) {
        super(fenetrePrincipale, n);
        this.algo = algo;
        this.libelleFichier = new JLabel("Choisisser un fichier :");
        this.texteFichier = new JTextField(32);
        this.boutonParcourir = new JButton("Parcourir ...");
        this.boutonParcourir.addActionListener(this);
    }

    public String getFichier() {
        if (this.texteFichier != null) {
            return this.texteFichier.getText();
        }
        return null;
    }

    public Algo getAlgo() {
        return this.algo;
    }

    public void affiche() {
        JFrame jFrame = this.fenetre.getFenetre();
        if (jFrame != null && jFrame.getContentPane() != null) {
            EcranUtil.supprimeTousLesComposants((JPanel)jFrame.getContentPane());
            ((JPanel)jFrame.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
            GridBagLayout gridBagLayout = new GridBagLayout();
            ((JPanel)jFrame.getContentPane()).setLayout(gridBagLayout);
            GridBagHelper gridBagHelper = new GridBagHelper(jFrame.getContentPane());
            gridBagHelper.ajoute(this.libelleFichier, EcranUtil.styleLibelleSaisieFichier, 0, 0, 1, 1);
            gridBagHelper.ajoute(this.texteFichier, EcranUtil.styleChampTexteFichier, 0, 1, 1, 1);
            gridBagHelper.ajoute(this.boutonParcourir, EcranUtil.styleBoutonParcourir, 0, 2, 1, 1);
            gridBagHelper.ajoute(this.soumettre, EcranUtil.styleBoutonSoumettre, 1, 0, 1, 3);
            gridBagHelper.ajoute(this.barreStatut, EcranUtil.styleBarreStatut, 2, 0, 1, 3);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        JFileChooser jFileChooser = new JFileChooser();
        JFrame jFrame = this.fenetre.getFenetre();
        int n = jFileChooser.showOpenDialog(jFrame);
        if (n == 0 && (file = jFileChooser.getSelectedFile()) != null) {
            this.texteFichier.setText(file.getAbsolutePath());
        }
    }
}

